/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.classification;

import data.structures.tagging.LemmaItem;

import java.util.Vector;

public class LemmePondere {

    private String lemme;
    private Vector<Operation> origine;
    private Vector<Double> poidsOrigine;
    private String categorie;
    private int diviseurTaille = 1;
    private double poidsCategorie = 1.0;
    private int nbOccurences;

    public LemmePondere(String lemme, Vector<Operation> origine, String categorie, int nbOccurences) {
        this.lemme = lemme;
        this.origine = origine;
        this.poidsOrigine = new Vector<Double>(origine.size());
        for(int i=0; i<poidsOrigine.size(); i++){
            poidsOrigine.setElementAt(new Double(1.0), i);
        }
        this.categorie = categorie;
        this.nbOccurences = nbOccurences;
    }

    public String getCategorie() {
        return categorie;
    }

    public double getPoidsCategorie() {
        return poidsCategorie;
    }

    public Vector<Operation> getOrigine() {
        return origine;
    }

    public double getPoidsOrigine() {
        double po = 1.0;
        for(int i=0; i<poidsOrigine.size(); i++){
            po *= poidsOrigine.elementAt(i).doubleValue();
        }
        return po / diviseurTaille;
    }

    public String getLemme() {
        return lemme;
    }

    public void pondereOrigine(Operation orig, double poids){
        for(int i=0; i<poidsOrigine.size(); i++){
            if(origine.elementAt(i).equals(orig)){
                poidsOrigine.setElementAt(new Double(poids), i);
            }
        }
    }

    public void pondereCategorie(double poids){
        this.poidsCategorie = poids;
    }

    public void pondereTaille(int taille){
        this.diviseurTaille = taille;
    }

    public int getNbOccurences(){
        return nbOccurences;
    }

    public void addNbOccurences(int nb){
        nbOccurences += nb;
    }

    /**
     * Forme une instance de LemmaItem, sans comptage du nombre d'occurences.
     * @return une instance de LemmaItem, sans comptage du nombre d'occurences.
     */
    public LemmaItem toLemmaItem(){
        LemmaItem l = new LemmaItem();
        l.setCountTitle(0);
        l.setCountDesc(0);
        l.setLemmaName(lemme);
        l.setLemmaLex(categorie);
        l.setNodeID(0);
        return l;
    }

    /* Attention : cette méthode sert à vérifier s'il y a des lemmes ayant le
     même nom et la même catégorie : les autres données peuvent varier
     sans gêner l'égalité.
     *
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final LemmePondere other = (LemmePondere) obj;
        if ((this.lemme == null) ? (other.lemme != null) : !this.lemme.equalsIgnoreCase(other.lemme)) {
            return false;
        }
        if(this.categorie == null || other.categorie == null) {
            return true;
        }
        if (!this.categorie.equalsIgnoreCase(other.categorie)) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode(){
        return lemme.hashCode();
    }
    
}
